package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TransactGetItem(get: zio.aws.dynamodb.model.Get) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactGetItem = {
    import TransactGetItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactGetItem
      .builder()
      .get(get.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactGetItem.ReadOnly =
    zio.aws.dynamodb.model.TransactGetItem.wrap(buildAwsValue())
}
object TransactGetItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactGetItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactGetItem =
      zio.aws.dynamodb.model.TransactGetItem(get.asEditable)
    def get: zio.aws.dynamodb.model.Get.ReadOnly
    def getGet: ZIO[Any, Nothing, zio.aws.dynamodb.model.Get.ReadOnly] =
      ZIO.succeed(get)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItem
  ) extends zio.aws.dynamodb.model.TransactGetItem.ReadOnly {
    override val get: zio.aws.dynamodb.model.Get.ReadOnly =
      zio.aws.dynamodb.model.Get.wrap(impl.get())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItem
  ): zio.aws.dynamodb.model.TransactGetItem.ReadOnly = new Wrapper(impl)
}
