package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GlobalSecondaryIndexUpdate(
    update: Option[zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction] =
      None,
    create: Option[zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction] =
      None,
    delete: Option[zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate = {
    import GlobalSecondaryIndexUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(create.map(value => value.buildAwsValue()))(_.create)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly =
    zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.wrap(buildAwsValue())
}
object GlobalSecondaryIndexUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate =
      zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate(
        update.map(value => value.asEditable),
        create.map(value => value.asEditable),
        delete.map(value => value.asEditable)
      )
    def update: Option[
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ]
    def create: Option[
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ]
    def delete: Option[
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ]
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getCreate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("create", create)
    def getDelete: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ] = AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ) extends zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly {
    override val update: Option[
      zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.ReadOnly
    ] = scala
      .Option(impl.update())
      .map(value =>
        zio.aws.dynamodb.model.UpdateGlobalSecondaryIndexAction.wrap(value)
      )
    override val create: Option[
      zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.ReadOnly
    ] = scala
      .Option(impl.create())
      .map(value =>
        zio.aws.dynamodb.model.CreateGlobalSecondaryIndexAction.wrap(value)
      )
    override val delete: Option[
      zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.ReadOnly
    ] = scala
      .Option(impl.delete())
      .map(value =>
        zio.aws.dynamodb.model.DeleteGlobalSecondaryIndexAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate
  ): zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate.ReadOnly = new Wrapper(
    impl
  )
}
