package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{AttributeName, TableName}
import scala.jdk.CollectionConverters._
final case class BatchStatementResponse(
    error: Option[zio.aws.dynamodb.model.BatchStatementError] = None,
    tableName: Option[TableName] = None,
    item: Option[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse = {
    import BatchStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        item.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.item)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly =
    zio.aws.dynamodb.model.BatchStatementResponse.wrap(buildAwsValue())
}
object BatchStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchStatementResponse =
      zio.aws.dynamodb.model.BatchStatementResponse(
        error.map(value => value.asEditable),
        tableName.map(value => value),
        item.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def error: Option[zio.aws.dynamodb.model.BatchStatementError.ReadOnly]
    def tableName: Option[TableName]
    def item: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BatchStatementError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getItem: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("item", item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse
  ) extends zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly {
    override val error
        : Option[zio.aws.dynamodb.model.BatchStatementError.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.dynamodb.model.BatchStatementError.wrap(value))
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val item: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.item())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse
  ): zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly = new Wrapper(impl)
}
