package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait BackupType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.BackupType
}
object BackupType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.BackupType
  ): zio.aws.dynamodb.model.BackupType = value match {
    case software.amazon.awssdk.services.dynamodb.model.BackupType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupType.SYSTEM =>
      val r = SYSTEM
      r
    case software.amazon.awssdk.services.dynamodb.model.BackupType.AWS_BACKUP =>
      val r = AWS_BACKUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupType =
      software.amazon.awssdk.services.dynamodb.model.BackupType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.dynamodb.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupType =
      software.amazon.awssdk.services.dynamodb.model.BackupType.USER
  }
  case object SYSTEM extends zio.aws.dynamodb.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupType =
      software.amazon.awssdk.services.dynamodb.model.BackupType.SYSTEM
  }
  case object AWS_BACKUP extends zio.aws.dynamodb.model.BackupType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BackupType =
      software.amazon.awssdk.services.dynamodb.model.BackupType.AWS_BACKUP
  }
}
