package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ExportStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ExportStatus
}
object ExportStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ExportStatus
  ): zio.aws.dynamodb.model.ExportStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.ExportStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.dynamodb.model.ExportStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportStatus =
      software.amazon.awssdk.services.dynamodb.model.ExportStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.dynamodb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportStatus =
      software.amazon.awssdk.services.dynamodb.model.ExportStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.dynamodb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportStatus =
      software.amazon.awssdk.services.dynamodb.model.ExportStatus.COMPLETED
  }
  case object FAILED extends zio.aws.dynamodb.model.ExportStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ExportStatus =
      software.amazon.awssdk.services.dynamodb.model.ExportStatus.FAILED
  }
}
