package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{NonNegativeLongObject, RegionName}
import scala.jdk.CollectionConverters._
final case class ReplicaSettingsDescription(
    regionName: RegionName,
    replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus] = None,
    replicaBillingModeSummary: Option[
      zio.aws.dynamodb.model.BillingModeSummary
    ] = None,
    replicaProvisionedReadCapacityUnits: Option[NonNegativeLongObject] = None,
    replicaProvisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None,
    replicaProvisionedWriteCapacityUnits: Option[NonNegativeLongObject] = None,
    replicaProvisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = None,
    replicaGlobalSecondaryIndexSettings: Option[Iterable[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
    ]] = None,
    replicaTableClassSummary: Option[zio.aws.dynamodb.model.TableClassSummary] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription = {
    import ReplicaSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(replicaStatus.map(value => value.unwrap))(_.replicaStatus)
      .optionallyWith(
        replicaBillingModeSummary.map(value => value.buildAwsValue())
      )(_.replicaBillingModeSummary)
      .optionallyWith(
        replicaProvisionedReadCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.replicaProvisionedReadCapacityUnits)
      .optionallyWith(
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        replicaProvisionedWriteCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.replicaProvisionedWriteCapacityUnits)
      .optionallyWith(
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedWriteCapacityAutoScalingSettings)
      .optionallyWith(
        replicaGlobalSecondaryIndexSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaGlobalSecondaryIndexSettings)
      .optionallyWith(
        replicaTableClassSummary.map(value => value.buildAwsValue())
      )(_.replicaTableClassSummary)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaSettingsDescription.wrap(buildAwsValue())
}
object ReplicaSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaSettingsDescription =
      zio.aws.dynamodb.model.ReplicaSettingsDescription(
        regionName,
        replicaStatus.map(value => value),
        replicaBillingModeSummary.map(value => value.asEditable),
        replicaProvisionedReadCapacityUnits.map(value => value),
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaProvisionedWriteCapacityUnits.map(value => value),
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaGlobalSecondaryIndexSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaTableClassSummary.map(value => value.asEditable)
      )
    def regionName: RegionName
    def replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus]
    def replicaBillingModeSummary
        : Option[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly]
    def replicaProvisionedReadCapacityUnits: Option[NonNegativeLongObject]
    def replicaProvisionedReadCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def replicaProvisionedWriteCapacityUnits: Option[NonNegativeLongObject]
    def replicaProvisionedWriteCapacityAutoScalingSettings
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly]
    def replicaGlobalSecondaryIndexSettings: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]]
    def replicaTableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getReplicaStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReplicaStatus] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaBillingModeSummary",
      replicaBillingModeSummary
    )
    def getReplicaProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField(
        "replicaProvisionedReadCapacityUnits",
        replicaProvisionedReadCapacityUnits
      )
    def getReplicaProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityAutoScalingSettings",
      replicaProvisionedReadCapacityAutoScalingSettings
    )
    def getReplicaProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField(
        "replicaProvisionedWriteCapacityUnits",
        replicaProvisionedWriteCapacityUnits
      )
    def getReplicaProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedWriteCapacityAutoScalingSettings",
      replicaProvisionedWriteCapacityAutoScalingSettings
    )
    def getReplicaGlobalSecondaryIndexSettings: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicaGlobalSecondaryIndexSettings",
      replicaGlobalSecondaryIndexSettings
    )
    def getReplicaTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaTableClassSummary",
      replicaTableClassSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ) extends zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus] =
      scala
        .Option(impl.replicaStatus())
        .map(value => zio.aws.dynamodb.model.ReplicaStatus.wrap(value))
    override val replicaBillingModeSummary
        : Option[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly] = scala
      .Option(impl.replicaBillingModeSummary())
      .map(value => zio.aws.dynamodb.model.BillingModeSummary.wrap(value))
    override val replicaProvisionedReadCapacityUnits
        : Option[NonNegativeLongObject] = scala
      .Option(impl.replicaProvisionedReadCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
    override val replicaProvisionedReadCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.replicaProvisionedReadCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaProvisionedWriteCapacityUnits
        : Option[NonNegativeLongObject] = scala
      .Option(impl.replicaProvisionedWriteCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
    override val replicaProvisionedWriteCapacityAutoScalingSettings: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = scala
      .Option(impl.replicaProvisionedWriteCapacityAutoScalingSettings())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaGlobalSecondaryIndexSettings: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]] = scala
      .Option(impl.replicaGlobalSecondaryIndexSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
            .wrap(item)
        }.toList
      )
    override val replicaTableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] = scala
      .Option(impl.replicaTableClassSummary())
      .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ): zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly = new Wrapper(
    impl
  )
}
