package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  IndexName,
  ConsumedCapacityUnits,
  TableName
}
import scala.jdk.CollectionConverters._
final case class ConsumedCapacity(
    tableName: Option[TableName] = None,
    capacityUnits: Option[ConsumedCapacityUnits] = None,
    readCapacityUnits: Option[ConsumedCapacityUnits] = None,
    writeCapacityUnits: Option[ConsumedCapacityUnits] = None,
    table: Option[zio.aws.dynamodb.model.Capacity] = None,
    localSecondaryIndexes: Option[
      Map[IndexName, zio.aws.dynamodb.model.Capacity]
    ] = None,
    globalSecondaryIndexes: Option[
      Map[IndexName, zio.aws.dynamodb.model.Capacity]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity = {
    import ConsumedCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        capacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.capacityUnits)
      .optionallyWith(
        readCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          ConsumedCapacityUnits.unwrap(value): java.lang.Double
        )
      )(_.writeCapacityUnits)
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value
            .map({ case (key, value) =>
              (IndexName.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value
            .map({ case (key, value) =>
              (IndexName.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.globalSecondaryIndexes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly =
    zio.aws.dynamodb.model.ConsumedCapacity.wrap(buildAwsValue())
}
object ConsumedCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ConsumedCapacity =
      zio.aws.dynamodb.model.ConsumedCapacity(
        tableName.map(value => value),
        capacityUnits.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value),
        table.map(value => value.asEditable),
        localSecondaryIndexes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        globalSecondaryIndexes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def tableName: Option[TableName]
    def capacityUnits: Option[ConsumedCapacityUnits]
    def readCapacityUnits: Option[ConsumedCapacityUnits]
    def writeCapacityUnits: Option[ConsumedCapacityUnits]
    def table: Option[zio.aws.dynamodb.model.Capacity.ReadOnly]
    def localSecondaryIndexes
        : Option[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]]
    def globalSecondaryIndexes
        : Option[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getReadCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, ConsumedCapacityUnits] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
    def getTable: ZIO[Any, AwsError, zio.aws.dynamodb.model.Capacity.ReadOnly] =
      AwsError.unwrapOptionField("table", table)
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, Map[
      IndexName,
      zio.aws.dynamodb.model.Capacity.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, Map[
      IndexName,
      zio.aws.dynamodb.model.Capacity.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ) extends zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val capacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.capacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
    override val readCapacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.readCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
    override val writeCapacityUnits: Option[ConsumedCapacityUnits] = scala
      .Option(impl.writeCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits(value)
      )
    override val table: Option[zio.aws.dynamodb.model.Capacity.ReadOnly] = scala
      .Option(impl.table())
      .map(value => zio.aws.dynamodb.model.Capacity.wrap(value))
    override val localSecondaryIndexes
        : Option[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]] =
      scala
        .Option(impl.localSecondaryIndexes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives
                .IndexName(key) -> zio.aws.dynamodb.model.Capacity.wrap(value)
            })
            .toMap
        )
    override val globalSecondaryIndexes
        : Option[Map[IndexName, zio.aws.dynamodb.model.Capacity.ReadOnly]] =
      scala
        .Option(impl.globalSecondaryIndexes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives
                .IndexName(key) -> zio.aws.dynamodb.model.Capacity.wrap(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity
  ): zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly = new Wrapper(impl)
}
