package zio.aws.dynamodb.model
import java.time.Instant
import zio.aws.dynamodb.model.primitives.{
  TableName,
  BackupArn,
  TimeRangeLowerBound,
  BackupsInputLimit,
  TimeRangeUpperBound
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBackupsRequest(
    tableName: Option[TableName] = None,
    limit: Option[BackupsInputLimit] = None,
    timeRangeLowerBound: Option[TimeRangeLowerBound] = None,
    timeRangeUpperBound: Option[TimeRangeUpperBound] = None,
    exclusiveStartBackupArn: Option[BackupArn] = None,
    backupType: Option[zio.aws.dynamodb.model.BackupTypeFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest = {
    import ListBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        limit.map(value => BackupsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        timeRangeLowerBound.map(value =>
          TimeRangeLowerBound.unwrap(value): Instant
        )
      )(_.timeRangeLowerBound)
      .optionallyWith(
        timeRangeUpperBound.map(value =>
          TimeRangeUpperBound.unwrap(value): Instant
        )
      )(_.timeRangeUpperBound)
      .optionallyWith(
        exclusiveStartBackupArn.map(value =>
          BackupArn.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartBackupArn)
      .optionallyWith(backupType.map(value => value.unwrap))(_.backupType)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListBackupsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListBackupsRequest.wrap(buildAwsValue())
}
object ListBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListBackupsRequest =
      zio.aws.dynamodb.model.ListBackupsRequest(
        tableName.map(value => value),
        limit.map(value => value),
        timeRangeLowerBound.map(value => value),
        timeRangeUpperBound.map(value => value),
        exclusiveStartBackupArn.map(value => value),
        backupType.map(value => value)
      )
    def tableName: Option[TableName]
    def limit: Option[BackupsInputLimit]
    def timeRangeLowerBound: Option[TimeRangeLowerBound]
    def timeRangeUpperBound: Option[TimeRangeUpperBound]
    def exclusiveStartBackupArn: Option[BackupArn]
    def backupType: Option[zio.aws.dynamodb.model.BackupTypeFilter]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getLimit: ZIO[Any, AwsError, BackupsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getTimeRangeLowerBound: ZIO[Any, AwsError, TimeRangeLowerBound] =
      AwsError.unwrapOptionField("timeRangeLowerBound", timeRangeLowerBound)
    def getTimeRangeUpperBound: ZIO[Any, AwsError, TimeRangeUpperBound] =
      AwsError.unwrapOptionField("timeRangeUpperBound", timeRangeUpperBound)
    def getExclusiveStartBackupArn: ZIO[Any, AwsError, BackupArn] = AwsError
      .unwrapOptionField("exclusiveStartBackupArn", exclusiveStartBackupArn)
    def getBackupType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BackupTypeFilter] =
      AwsError.unwrapOptionField("backupType", backupType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest
  ) extends zio.aws.dynamodb.model.ListBackupsRequest.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val limit: Option[BackupsInputLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.dynamodb.model.primitives.BackupsInputLimit(value))
    override val timeRangeLowerBound: Option[TimeRangeLowerBound] = scala
      .Option(impl.timeRangeLowerBound())
      .map(value =>
        zio.aws.dynamodb.model.primitives.TimeRangeLowerBound(value)
      )
    override val timeRangeUpperBound: Option[TimeRangeUpperBound] = scala
      .Option(impl.timeRangeUpperBound())
      .map(value =>
        zio.aws.dynamodb.model.primitives.TimeRangeUpperBound(value)
      )
    override val exclusiveStartBackupArn: Option[BackupArn] = scala
      .Option(impl.exclusiveStartBackupArn())
      .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
    override val backupType: Option[zio.aws.dynamodb.model.BackupTypeFilter] =
      scala
        .Option(impl.backupType())
        .map(value => zio.aws.dynamodb.model.BackupTypeFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest
  ): zio.aws.dynamodb.model.ListBackupsRequest.ReadOnly = new Wrapper(impl)
}
