package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DescribeGlobalTableSettingsResponse(
    globalTableName: Option[TableName] = None,
    replicaSettings: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaSettingsDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse = {
    import DescribeGlobalTableSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse
      .builder()
      .optionallyWith(
        globalTableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.globalTableName)
      .optionallyWith(
        replicaSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeGlobalTableSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse =
      zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse(
        globalTableName.map(value => value),
        replicaSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalTableName: Option[TableName]
    def replicaSettings: Option[
      List[zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly]
    ]
    def getGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("globalTableName", globalTableName)
    def getReplicaSettings: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicaSettings", replicaSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse
  ) extends zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly {
    override val globalTableName: Option[TableName] = scala
      .Option(impl.globalTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val replicaSettings: Option[
      List[zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly]
    ] = scala
      .Option(impl.replicaSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaSettingsDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse
  ): zio.aws.dynamodb.model.DescribeGlobalTableSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
