package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{ListTablesInputLimit, TableName}
import scala.jdk.CollectionConverters._
final case class ListTablesRequest(
    exclusiveStartTableName: Option[TableName] = None,
    limit: Option[ListTablesInputLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListTablesRequest = {
    import ListTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
      .builder()
      .optionallyWith(
        exclusiveStartTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTableName)
      .optionallyWith(
        limit.map(value => ListTablesInputLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListTablesRequest.ReadOnly =
    zio.aws.dynamodb.model.ListTablesRequest.wrap(buildAwsValue())
}
object ListTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListTablesRequest =
      zio.aws.dynamodb.model.ListTablesRequest(
        exclusiveStartTableName.map(value => value),
        limit.map(value => value)
      )
    def exclusiveStartTableName: Option[TableName]
    def limit: Option[ListTablesInputLimit]
    def getExclusiveStartTableName: ZIO[Any, AwsError, TableName] = AwsError
      .unwrapOptionField("exclusiveStartTableName", exclusiveStartTableName)
    def getLimit: ZIO[Any, AwsError, ListTablesInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ) extends zio.aws.dynamodb.model.ListTablesRequest.ReadOnly {
    override val exclusiveStartTableName: Option[TableName] = scala
      .Option(impl.exclusiveStartTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val limit: Option[ListTablesInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ListTablesInputLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListTablesRequest
  ): zio.aws.dynamodb.model.ListTablesRequest.ReadOnly = new Wrapper(impl)
}
