package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DeleteTableRequest(tableName: TableName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest = {
    import DeleteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteTableRequest.ReadOnly =
    zio.aws.dynamodb.model.DeleteTableRequest.wrap(buildAwsValue())
}
object DeleteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteTableRequest =
      zio.aws.dynamodb.model.DeleteTableRequest(tableName)
    def tableName: TableName
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest
  ) extends zio.aws.dynamodb.model.DeleteTableRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest
  ): zio.aws.dynamodb.model.DeleteTableRequest.ReadOnly = new Wrapper(impl)
}
