package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  AttributeName,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ExpressionAttributeValueVariable
}
import scala.jdk.CollectionConverters._
final case class PutItemRequest(
    tableName: TableName,
    item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    expected: Option[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue]
    ] = None,
    returnValues: Option[zio.aws.dynamodb.model.ReturnValue] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None,
    returnItemCollectionMetrics: Option[
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = None,
    conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator] =
      None,
    conditionExpression: Option[ConditionExpression] = None,
    expressionAttributeNames: Option[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = None,
    expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PutItemRequest = {
    import PutItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PutItemRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .item(
        item
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        expected.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.expected)
      .optionallyWith(returnValues.map(value => value.unwrap))(_.returnValues)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(returnItemCollectionMetrics.map(value => value.unwrap))(
        _.returnItemCollectionMetrics
      )
      .optionallyWith(conditionalOperator.map(value => value.unwrap))(
        _.conditionalOperator
      )
      .optionallyWith(
        conditionExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.conditionExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable
                .unwrap(key): java.lang.String) -> (AttributeName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.PutItemRequest.ReadOnly =
    zio.aws.dynamodb.model.PutItemRequest.wrap(buildAwsValue())
}
object PutItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PutItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PutItemRequest =
      zio.aws.dynamodb.model.PutItemRequest(
        tableName,
        item.map({ case (key, value) =>
          key -> value.asEditable
        }),
        expected.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        returnValues.map(value => value),
        returnConsumedCapacity.map(value => value),
        returnItemCollectionMetrics.map(value => value),
        conditionalOperator.map(value => value),
        conditionExpression.map(value => value),
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def tableName: TableName
    def item: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def expected: Option[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly]
    ]
    def returnValues: Option[zio.aws.dynamodb.model.ReturnValue]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def returnItemCollectionMetrics
        : Option[zio.aws.dynamodb.model.ReturnItemCollectionMetrics]
    def conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator]
    def conditionExpression: Option[ConditionExpression]
    def expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getItem: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(item)
    def getExpected: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("expected", expected)
    def getReturnValues
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnValue] =
      AwsError.unwrapOptionField("returnValues", returnValues)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getReturnItemCollectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnItemCollectionMetrics
    ] = AwsError.unwrapOptionField(
      "returnItemCollectionMetrics",
      returnItemCollectionMetrics
    )
    def getConditionalOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionalOperator] =
      AwsError.unwrapOptionField("conditionalOperator", conditionalOperator)
    def getConditionExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("conditionExpression", conditionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PutItemRequest
  ) extends zio.aws.dynamodb.model.PutItemRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val item
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .item()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val expected: Option[
      Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly]
    ] = scala
      .Option(impl.expected())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.ExpectedAttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnValues: Option[zio.aws.dynamodb.model.ReturnValue] =
      scala
        .Option(impl.returnValues())
        .map(value => zio.aws.dynamodb.model.ReturnValue.wrap(value))
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val returnItemCollectionMetrics
        : Option[zio.aws.dynamodb.model.ReturnItemCollectionMetrics] = scala
      .Option(impl.returnItemCollectionMetrics())
      .map(value =>
        zio.aws.dynamodb.model.ReturnItemCollectionMetrics.wrap(value)
      )
    override val conditionalOperator
        : Option[zio.aws.dynamodb.model.ConditionalOperator] = scala
      .Option(impl.conditionalOperator())
      .map(value => zio.aws.dynamodb.model.ConditionalOperator.wrap(value))
    override val conditionExpression: Option[ConditionExpression] = scala
      .Option(impl.conditionExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConditionExpression(value)
      )
    override val expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]] = scala
      .Option(impl.expressionAttributeNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
              key
            ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
          })
          .toMap
      )
    override val expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = scala
      .Option(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PutItemRequest
  ): zio.aws.dynamodb.model.PutItemRequest.ReadOnly = new Wrapper(impl)
}
