package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ExportTime,
  ExportStartTime,
  S3Prefix,
  S3BucketOwner,
  S3SseKmsKeyId,
  ItemCount,
  ExportManifest,
  ExportEndTime,
  ExportArn,
  TableArn,
  ClientToken,
  BilledSizeBytes,
  FailureCode,
  FailureMessage,
  S3Bucket,
  TableId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExportDescription(
    exportArn: Option[ExportArn] = None,
    exportStatus: Option[zio.aws.dynamodb.model.ExportStatus] = None,
    startTime: Option[ExportStartTime] = None,
    endTime: Option[ExportEndTime] = None,
    exportManifest: Option[ExportManifest] = None,
    tableArn: Option[TableArn] = None,
    tableId: Option[TableId] = None,
    exportTime: Option[ExportTime] = None,
    clientToken: Option[ClientToken] = None,
    s3Bucket: Option[S3Bucket] = None,
    s3BucketOwner: Option[S3BucketOwner] = None,
    s3Prefix: Option[S3Prefix] = None,
    s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm] = None,
    s3SseKmsKeyId: Option[S3SseKmsKeyId] = None,
    failureCode: Option[FailureCode] = None,
    failureMessage: Option[FailureMessage] = None,
    exportFormat: Option[zio.aws.dynamodb.model.ExportFormat] = None,
    billedSizeBytes: Option[BilledSizeBytes] = None,
    itemCount: Option[ItemCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportDescription = {
    import ExportDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportDescription
      .builder()
      .optionallyWith(
        exportArn.map(value => ExportArn.unwrap(value): java.lang.String)
      )(_.exportArn)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        startTime.map(value => ExportStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ExportEndTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        exportManifest.map(value =>
          ExportManifest.unwrap(value): java.lang.String
        )
      )(_.exportManifest)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        exportTime.map(value => ExportTime.unwrap(value): Instant)
      )(_.exportTime)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3BucketOwner.map(value =>
          S3BucketOwner.unwrap(value): java.lang.String
        )
      )(_.s3BucketOwner)
      .optionallyWith(
        s3Prefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .optionallyWith(s3SseAlgorithm.map(value => value.unwrap))(
        _.s3SseAlgorithm
      )
      .optionallyWith(
        s3SseKmsKeyId.map(value =>
          S3SseKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.s3SseKmsKeyId)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value =>
          FailureMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(exportFormat.map(value => value.unwrap))(_.exportFormat)
      .optionallyWith(
        billedSizeBytes.map(value =>
          BilledSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.billedSizeBytes)
      .optionallyWith(
        itemCount.map(value => ItemCount.unwrap(value): java.lang.Long)
      )(_.itemCount)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExportDescription.ReadOnly =
    zio.aws.dynamodb.model.ExportDescription.wrap(buildAwsValue())
}
object ExportDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportDescription =
      zio.aws.dynamodb.model.ExportDescription(
        exportArn.map(value => value),
        exportStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        exportManifest.map(value => value),
        tableArn.map(value => value),
        tableId.map(value => value),
        exportTime.map(value => value),
        clientToken.map(value => value),
        s3Bucket.map(value => value),
        s3BucketOwner.map(value => value),
        s3Prefix.map(value => value),
        s3SseAlgorithm.map(value => value),
        s3SseKmsKeyId.map(value => value),
        failureCode.map(value => value),
        failureMessage.map(value => value),
        exportFormat.map(value => value),
        billedSizeBytes.map(value => value),
        itemCount.map(value => value)
      )
    def exportArn: Option[ExportArn]
    def exportStatus: Option[zio.aws.dynamodb.model.ExportStatus]
    def startTime: Option[ExportStartTime]
    def endTime: Option[ExportEndTime]
    def exportManifest: Option[ExportManifest]
    def tableArn: Option[TableArn]
    def tableId: Option[TableId]
    def exportTime: Option[ExportTime]
    def clientToken: Option[ClientToken]
    def s3Bucket: Option[S3Bucket]
    def s3BucketOwner: Option[S3BucketOwner]
    def s3Prefix: Option[S3Prefix]
    def s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm]
    def s3SseKmsKeyId: Option[S3SseKmsKeyId]
    def failureCode: Option[FailureCode]
    def failureMessage: Option[FailureMessage]
    def exportFormat: Option[zio.aws.dynamodb.model.ExportFormat]
    def billedSizeBytes: Option[BilledSizeBytes]
    def itemCount: Option[ItemCount]
    def getExportArn: ZIO[Any, AwsError, ExportArn] =
      AwsError.unwrapOptionField("exportArn", exportArn)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getStartTime: ZIO[Any, AwsError, ExportStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ExportEndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getExportManifest: ZIO[Any, AwsError, ExportManifest] =
      AwsError.unwrapOptionField("exportManifest", exportManifest)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getExportTime: ZIO[Any, AwsError, ExportTime] =
      AwsError.unwrapOptionField("exportTime", exportTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, S3BucketOwner] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Prefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3SseAlgorithm
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3SseAlgorithm] =
      AwsError.unwrapOptionField("s3SseAlgorithm", s3SseAlgorithm)
    def getS3SseKmsKeyId: ZIO[Any, AwsError, S3SseKmsKeyId] =
      AwsError.unwrapOptionField("s3SseKmsKeyId", s3SseKmsKeyId)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, FailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getExportFormat
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportFormat] =
      AwsError.unwrapOptionField("exportFormat", exportFormat)
    def getBilledSizeBytes: ZIO[Any, AwsError, BilledSizeBytes] =
      AwsError.unwrapOptionField("billedSizeBytes", billedSizeBytes)
    def getItemCount: ZIO[Any, AwsError, ItemCount] =
      AwsError.unwrapOptionField("itemCount", itemCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ) extends zio.aws.dynamodb.model.ExportDescription.ReadOnly {
    override val exportArn: Option[ExportArn] = scala
      .Option(impl.exportArn())
      .map(value => zio.aws.dynamodb.model.primitives.ExportArn(value))
    override val exportStatus: Option[zio.aws.dynamodb.model.ExportStatus] =
      scala
        .Option(impl.exportStatus())
        .map(value => zio.aws.dynamodb.model.ExportStatus.wrap(value))
    override val startTime: Option[ExportStartTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportStartTime(value))
    override val endTime: Option[ExportEndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportEndTime(value))
    override val exportManifest: Option[ExportManifest] = scala
      .Option(impl.exportManifest())
      .map(value => zio.aws.dynamodb.model.primitives.ExportManifest(value))
    override val tableArn: Option[TableArn] = scala
      .Option(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val tableId: Option[TableId] = scala
      .Option(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val exportTime: Option[ExportTime] = scala
      .Option(impl.exportTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportTime(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.dynamodb.model.primitives.S3Bucket(value))
    override val s3BucketOwner: Option[S3BucketOwner] = scala
      .Option(impl.s3BucketOwner())
      .map(value => zio.aws.dynamodb.model.primitives.S3BucketOwner(value))
    override val s3Prefix: Option[S3Prefix] = scala
      .Option(impl.s3Prefix())
      .map(value => zio.aws.dynamodb.model.primitives.S3Prefix(value))
    override val s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm] =
      scala
        .Option(impl.s3SseAlgorithm())
        .map(value => zio.aws.dynamodb.model.S3SseAlgorithm.wrap(value))
    override val s3SseKmsKeyId: Option[S3SseKmsKeyId] = scala
      .Option(impl.s3SseKmsKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.S3SseKmsKeyId(value))
    override val failureCode: Option[FailureCode] = scala
      .Option(impl.failureCode())
      .map(value => zio.aws.dynamodb.model.primitives.FailureCode(value))
    override val failureMessage: Option[FailureMessage] = scala
      .Option(impl.failureMessage())
      .map(value => zio.aws.dynamodb.model.primitives.FailureMessage(value))
    override val exportFormat: Option[zio.aws.dynamodb.model.ExportFormat] =
      scala
        .Option(impl.exportFormat())
        .map(value => zio.aws.dynamodb.model.ExportFormat.wrap(value))
    override val billedSizeBytes: Option[BilledSizeBytes] = scala
      .Option(impl.billedSizeBytes())
      .map(value => zio.aws.dynamodb.model.primitives.BilledSizeBytes(value))
    override val itemCount: Option[ItemCount] = scala
      .Option(impl.itemCount())
      .map(value => zio.aws.dynamodb.model.primitives.ItemCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ): zio.aws.dynamodb.model.ExportDescription.ReadOnly = new Wrapper(impl)
}
