package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTableResponse(
    table: Option[zio.aws.dynamodb.model.TableDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse = {
    import DescribeTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse
      .builder()
      .optionallyWith(table.map(value => value.buildAwsValue()))(_.table)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeTableResponse.wrap(buildAwsValue())
}
object DescribeTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeTableResponse =
      zio.aws.dynamodb.model
        .DescribeTableResponse(table.map(value => value.asEditable))
    def table: Option[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTable
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("table", table)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse
  ) extends zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly {
    override val table
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly] = scala
      .Option(impl.table())
      .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse
  ): zio.aws.dynamodb.model.DescribeTableResponse.ReadOnly = new Wrapper(impl)
}
