package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteTransactionResponse(
    responses: Optional[Iterable[zio.aws.dynamodb.model.ItemResponse]] =
      Optional.Absent,
    consumedCapacity: Optional[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse = {
    import ExecuteTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly =
    zio.aws.dynamodb.model.ExecuteTransactionResponse.wrap(buildAwsValue())
}
object ExecuteTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteTransactionResponse =
      zio.aws.dynamodb.model.ExecuteTransactionResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses: Optional[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]]
    def consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ) extends zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly {
    override val responses
        : Optional[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ItemResponse.wrap(item)
          }.toList
        )
    override val consumedCapacity
        : Optional[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consumedCapacity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ): zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly = new Wrapper(
    impl
  )
}
