package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ContributorInsightsAction {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction
}
object ContributorInsightsAction {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction
  ): zio.aws.dynamodb.model.ContributorInsightsAction = value match {
    case software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ContributorInsightsAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction =
      software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.dynamodb.model.ContributorInsightsAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction =
      software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.ENABLE
  }
  case object DISABLE extends zio.aws.dynamodb.model.ContributorInsightsAction {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction =
      software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction.DISABLE
  }
}
