package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBackupResponse(
    backupDescription: Optional[zio.aws.dynamodb.model.BackupDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse = {
    import DescribeBackupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse
      .builder()
      .optionallyWith(backupDescription.map(value => value.buildAwsValue()))(
        _.backupDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeBackupResponse.wrap(buildAwsValue())
}
object DescribeBackupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeBackupResponse =
      zio.aws.dynamodb.model.DescribeBackupResponse(
        backupDescription.map(value => value.asEditable)
      )
    def backupDescription
        : Optional[zio.aws.dynamodb.model.BackupDescription.ReadOnly]
    def getBackupDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BackupDescription.ReadOnly
    ] = AwsError.unwrapOptionField("backupDescription", backupDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse
  ) extends zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly {
    override val backupDescription
        : Optional[zio.aws.dynamodb.model.BackupDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupDescription())
        .map(value => zio.aws.dynamodb.model.BackupDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse
  ): zio.aws.dynamodb.model.DescribeBackupResponse.ReadOnly = new Wrapper(impl)
}
