package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGlobalTableResponse(
    globalTableDescription: Optional[
      zio.aws.dynamodb.model.GlobalTableDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse = {
    import UpdateGlobalTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse
      .builder()
      .optionallyWith(
        globalTableDescription.map(value => value.buildAwsValue())
      )(_.globalTableDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalTableResponse.wrap(buildAwsValue())
}
object UpdateGlobalTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalTableResponse =
      zio.aws.dynamodb.model.UpdateGlobalTableResponse(
        globalTableDescription.map(value => value.asEditable)
      )
    def globalTableDescription
        : Optional[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly]
    def getGlobalTableDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalTableDescription",
      globalTableDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse
  ) extends zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly {
    override val globalTableDescription
        : Optional[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalTableDescription())
        .map(value => zio.aws.dynamodb.model.GlobalTableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse
  ): zio.aws.dynamodb.model.UpdateGlobalTableResponse.ReadOnly = new Wrapper(
    impl
  )
}
