package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait PointInTimeRecoveryStatus {
  def unwrap
      : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus
}
object PointInTimeRecoveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus
  ): zio.aws.dynamodb.model.PointInTimeRecoveryStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.dynamodb.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.dynamodb.model.PointInTimeRecoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus =
      software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus.DISABLED
  }
}
