package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AutoScalingPolicyName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingPolicyDescription(
    policyName: Optional[AutoScalingPolicyName] = Optional.Absent,
    targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription = {
    import AutoScalingPolicyDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription
      .builder()
      .optionallyWith(
        policyName.map(value =>
          AutoScalingPolicyName.unwrap(value): java.lang.String
        )
      )(_.policyName)
      .optionallyWith(
        targetTrackingScalingPolicyConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.targetTrackingScalingPolicyConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly =
    zio.aws.dynamodb.model.AutoScalingPolicyDescription.wrap(buildAwsValue())
}
object AutoScalingPolicyDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AutoScalingPolicyDescription =
      zio.aws.dynamodb.model.AutoScalingPolicyDescription(
        policyName.map(value => value),
        targetTrackingScalingPolicyConfiguration.map(value => value.asEditable)
      )
    def policyName: Optional[AutoScalingPolicyName]
    def targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly
    ]
    def getPolicyName: ZIO[Any, AwsError, AutoScalingPolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getTargetTrackingScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetTrackingScalingPolicyConfiguration",
      targetTrackingScalingPolicyConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription
  ) extends zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly {
    override val policyName: Optional[AutoScalingPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyName())
        .map(value =>
          zio.aws.dynamodb.model.primitives.AutoScalingPolicyName(value)
        )
    override val targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTrackingScalingPolicyConfiguration())
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription
  ): zio.aws.dynamodb.model.AutoScalingPolicyDescription.ReadOnly = new Wrapper(
    impl
  )
}
