package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{NonNegativeLongObject, RegionName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaSettingsDescription(
    regionName: RegionName,
    replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      Optional.Absent,
    replicaBillingModeSummary: Optional[
      zio.aws.dynamodb.model.BillingModeSummary
    ] = Optional.Absent,
    replicaProvisionedReadCapacityUnits: Optional[NonNegativeLongObject] =
      Optional.Absent,
    replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent,
    replicaProvisionedWriteCapacityUnits: Optional[NonNegativeLongObject] =
      Optional.Absent,
    replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent,
    replicaGlobalSecondaryIndexSettings: Optional[Iterable[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
    ]] = Optional.Absent,
    replicaTableClassSummary: Optional[
      zio.aws.dynamodb.model.TableClassSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription = {
    import ReplicaSettingsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(replicaStatus.map(value => value.unwrap))(_.replicaStatus)
      .optionallyWith(
        replicaBillingModeSummary.map(value => value.buildAwsValue())
      )(_.replicaBillingModeSummary)
      .optionallyWith(
        replicaProvisionedReadCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.replicaProvisionedReadCapacityUnits)
      .optionallyWith(
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        replicaProvisionedWriteCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.replicaProvisionedWriteCapacityUnits)
      .optionallyWith(
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedWriteCapacityAutoScalingSettings)
      .optionallyWith(
        replicaGlobalSecondaryIndexSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaGlobalSecondaryIndexSettings)
      .optionallyWith(
        replicaTableClassSummary.map(value => value.buildAwsValue())
      )(_.replicaTableClassSummary)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaSettingsDescription.wrap(buildAwsValue())
}
object ReplicaSettingsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaSettingsDescription =
      zio.aws.dynamodb.model.ReplicaSettingsDescription(
        regionName,
        replicaStatus.map(value => value),
        replicaBillingModeSummary.map(value => value.asEditable),
        replicaProvisionedReadCapacityUnits.map(value => value),
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaProvisionedWriteCapacityUnits.map(value => value),
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaGlobalSecondaryIndexSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaTableClassSummary.map(value => value.asEditable)
      )
    def regionName: RegionName
    def replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus]
    def replicaBillingModeSummary
        : Optional[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly]
    def replicaProvisionedReadCapacityUnits: Optional[NonNegativeLongObject]
    def replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def replicaProvisionedWriteCapacityUnits: Optional[NonNegativeLongObject]
    def replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def replicaGlobalSecondaryIndexSettings: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]]
    def replicaTableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getReplicaStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReplicaStatus] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaBillingModeSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.BillingModeSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaBillingModeSummary",
      replicaBillingModeSummary
    )
    def getReplicaProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField(
        "replicaProvisionedReadCapacityUnits",
        replicaProvisionedReadCapacityUnits
      )
    def getReplicaProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityAutoScalingSettings",
      replicaProvisionedReadCapacityAutoScalingSettings
    )
    def getReplicaProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField(
        "replicaProvisionedWriteCapacityUnits",
        replicaProvisionedWriteCapacityUnits
      )
    def getReplicaProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedWriteCapacityAutoScalingSettings",
      replicaProvisionedWriteCapacityAutoScalingSettings
    )
    def getReplicaGlobalSecondaryIndexSettings: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicaGlobalSecondaryIndexSettings",
      replicaGlobalSecondaryIndexSettings
    )
    def getReplicaTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaTableClassSummary",
      replicaTableClassSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ) extends zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaStatus())
        .map(value => zio.aws.dynamodb.model.ReplicaStatus.wrap(value))
    override val replicaBillingModeSummary
        : Optional[zio.aws.dynamodb.model.BillingModeSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaBillingModeSummary())
        .map(value => zio.aws.dynamodb.model.BillingModeSummary.wrap(value))
    override val replicaProvisionedReadCapacityUnits
        : Optional[NonNegativeLongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaProvisionedReadCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
    override val replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.replicaProvisionedReadCapacityAutoScalingSettings()
      )
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaProvisionedWriteCapacityUnits
        : Optional[NonNegativeLongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaProvisionedWriteCapacityUnits())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
      )
    override val replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.replicaProvisionedWriteCapacityAutoScalingSettings()
      )
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaGlobalSecondaryIndexSettings: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaGlobalSecondaryIndexSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription
            .wrap(item)
        }.toList
      )
    override val replicaTableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaTableClassSummary())
        .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription
  ): zio.aws.dynamodb.model.ReplicaSettingsDescription.ReadOnly = new Wrapper(
    impl
  )
}
