package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String,
    resetAllParameters: Optional[Boolean] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.docdb.model.Parameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest = {
    import ResetDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .optionallyWith(
        resetAllParameters.map(value => value: java.lang.Boolean)
      )(_.resetAllParameters)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ResetDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.docdb.model.ResetDbClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object ResetDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ResetDbClusterParameterGroupRequest =
      zio.aws.docdb.model.ResetDbClusterParameterGroupRequest(
        dbClusterParameterGroupName,
        resetAllParameters.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterParameterGroupName: String
    def resetAllParameters: Optional[Boolean]
    def parameters: Optional[List[zio.aws.docdb.model.Parameter.ReadOnly]]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getResetAllParameters: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("resetAllParameters", resetAllParameters)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest
  ) extends zio.aws.docdb.model.ResetDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val resetAllParameters: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.resetAllParameters())
      .map(value => value: Boolean)
    override val parameters
        : Optional[List[zio.aws.docdb.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Parameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest
  ): zio.aws.docdb.model.ResetDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
