package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PendingCloudwatchLogsExports(
    logTypesToEnable: Optional[Iterable[String]] = Optional.Absent,
    logTypesToDisable: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports = {
    import PendingCloudwatchLogsExports.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
      .builder()
      .optionallyWith(
        logTypesToEnable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToEnable)
      .optionallyWith(
        logTypesToDisable.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logTypesToDisable)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly =
    zio.aws.docdb.model.PendingCloudwatchLogsExports.wrap(buildAwsValue())
}
object PendingCloudwatchLogsExports {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.PendingCloudwatchLogsExports =
      zio.aws.docdb.model.PendingCloudwatchLogsExports(
        logTypesToEnable.map(value => value),
        logTypesToDisable.map(value => value)
      )
    def logTypesToEnable: Optional[List[String]]
    def logTypesToDisable: Optional[List[String]]
    def getLogTypesToEnable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToEnable", logTypesToEnable)
    def getLogTypesToDisable: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logTypesToDisable", logTypesToDisable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ) extends zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly {
    override val logTypesToEnable: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToEnable())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val logTypesToDisable: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypesToDisable())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.PendingCloudwatchLogsExports
  ): zio.aws.docdb.model.PendingCloudwatchLogsExports.ReadOnly = new Wrapper(
    impl
  )
}
