package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParameterGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterParameterGroups: Optional[
      Iterable[zio.aws.docdb.model.DBClusterParameterGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse = {
    import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterParameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse =
      zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse(
        marker.map(value => value),
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterParameterGroups
        : Optional[List[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterParameterGroups",
      dbClusterParameterGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ) extends zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterParameterGroups
        : Optional[List[zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.DBClusterParameterGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse
  ): zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
