package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterSnapshotAttributeResponse(
    dbClusterSnapshotAttributesResult: Optional[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse = {
    import ModifyDbClusterSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
      .builder()
      .optionallyWith(
        dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbClusterSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse =
      zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse(
        dbClusterSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbClusterSnapshotAttributesResult: Optional[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ]
    def getDbClusterSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributesResult",
      dbClusterSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ) extends zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly {
    override val dbClusterSnapshotAttributesResult: Optional[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterSnapshotAttributesResult())
      .map(value =>
        zio.aws.docdb.model.DBClusterSnapshotAttributesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ): zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
