package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterRequest(
    dbClusterIdentifier: String,
    newDBClusterIdentifier: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    cloudwatchLogsExportConfiguration: Optional[
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration
    ] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        newDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.newDBClusterIdentifier)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbClusterRequest =
      zio.aws.docdb.model.ModifyDbClusterRequest(
        dbClusterIdentifier,
        newDBClusterIdentifier.map(value => value),
        applyImmediately.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        port.map(value => value),
        masterUserPassword.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        engineVersion.map(value => value),
        deletionProtection.map(value => value)
      )
    def dbClusterIdentifier: String
    def newDBClusterIdentifier: Optional[String]
    def applyImmediately: Optional[Boolean]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def port: Optional[IntegerOptional]
    def masterUserPassword: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def cloudwatchLogsExportConfiguration: Optional[
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly
    ]
    def engineVersion: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getNewDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifier)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ) extends zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val newDBClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBClusterIdentifier())
        .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val cloudwatchLogsExportConfiguration: Optional[
      zio.aws.docdb.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.docdb.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest
  ): zio.aws.docdb.model.ModifyDbClusterRequest.ReadOnly = new Wrapper(impl)
}
