package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest = {
    import DeleteDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DeleteDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.docdb.model.DeleteDbClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object DeleteDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteDbClusterParameterGroupRequest =
      zio.aws.docdb.model
        .DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupName)
    def dbClusterParameterGroupName: String
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest
  ) extends zio.aws.docdb.model.DeleteDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest
  ): zio.aws.docdb.model.DeleteDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
