package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EngineDefaults(
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.docdb.model.Parameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.EngineDefaults = {
    import EngineDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.EngineDefaults
      .builder()
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.EngineDefaults.ReadOnly =
    zio.aws.docdb.model.EngineDefaults.wrap(buildAwsValue())
}
object EngineDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.EngineDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.EngineDefaults =
      zio.aws.docdb.model.EngineDefaults(
        dbParameterGroupFamily.map(value => value),
        marker.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbParameterGroupFamily: Optional[String]
    def marker: Optional[String]
    def parameters: Optional[List[zio.aws.docdb.model.Parameter.ReadOnly]]
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.EngineDefaults
  ) extends zio.aws.docdb.model.EngineDefaults.ReadOnly {
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val parameters
        : Optional[List[zio.aws.docdb.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Parameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.EngineDefaults
  ): zio.aws.docdb.model.EngineDefaults.ReadOnly = new Wrapper(impl)
}
