package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subnet(
    subnetIdentifier: Optional[String] = Optional.Absent,
    subnetAvailabilityZone: Optional[zio.aws.docdb.model.AvailabilityZone] =
      Optional.Absent,
    subnetStatus: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.docdb.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetStatus.map(value => value: java.lang.String))(
        _.subnetStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.Subnet.ReadOnly =
    zio.aws.docdb.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.docdb.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.Subnet = zio.aws.docdb.model.Subnet(
      subnetIdentifier.map(value => value),
      subnetAvailabilityZone.map(value => value.asEditable),
      subnetStatus.map(value => value)
    )
    def subnetIdentifier: Optional[String]
    def subnetAvailabilityZone
        : Optional[zio.aws.docdb.model.AvailabilityZone.ReadOnly]
    def subnetStatus: Optional[String]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone
        : ZIO[Any, AwsError, zio.aws.docdb.model.AvailabilityZone.ReadOnly] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetStatus", subnetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.Subnet
  ) extends zio.aws.docdb.model.Subnet.ReadOnly {
    override val subnetIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIdentifier())
      .map(value => value: String)
    override val subnetAvailabilityZone
        : Optional[zio.aws.docdb.model.AvailabilityZone.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetAvailabilityZone())
        .map(value => zio.aws.docdb.model.AvailabilityZone.wrap(value))
    override val subnetStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetStatus())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.Subnet
  ): zio.aws.docdb.model.Subnet.ReadOnly = new Wrapper(impl)
}
