package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.docdb.model.primitives.{BooleanOptional, GlobalClusterIdentifier}
import scala.jdk.CollectionConverters._
final case class ModifyGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest = {
    import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        newGlobalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.newGlobalClusterIdentifier)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyGlobalClusterRequest.ReadOnly =
    zio.aws.docdb.model.ModifyGlobalClusterRequest.wrap(buildAwsValue())
}
object ModifyGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyGlobalClusterRequest =
      zio.aws.docdb.model.ModifyGlobalClusterRequest(
        globalClusterIdentifier,
        newGlobalClusterIdentifier.map(value => value),
        deletionProtection.map(value => value)
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier]
    def deletionProtection: Optional[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getNewGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] =
      AwsError.unwrapOptionField(
        "newGlobalClusterIdentifier",
        newGlobalClusterIdentifier
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest
  ) extends zio.aws.docdb.model.ModifyGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.docdb.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGlobalClusterIdentifier())
        .map(value =>
          zio.aws.docdb.model.primitives.GlobalClusterIdentifier(value)
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest
  ): zio.aws.docdb.model.ModifyGlobalClusterRequest.ReadOnly = new Wrapper(impl)
}
