package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyEventSubscriptionResponse(
    eventSubscription: Optional[zio.aws.docdb.model.EventSubscription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse = {
    import ModifyEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly =
    zio.aws.docdb.model.ModifyEventSubscriptionResponse.wrap(buildAwsValue())
}
object ModifyEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyEventSubscriptionResponse =
      zio.aws.docdb.model.ModifyEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Optional[zio.aws.docdb.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.docdb.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse
  ) extends zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Optional[zio.aws.docdb.model.EventSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscription())
        .map(value => zio.aws.docdb.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse
  ): zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
