package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbSubnetGroupRequest(
    dbSubnetGroupName: String,
    dbSubnetGroupDescription: Optional[String] = Optional.Absent,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest = {
    import ModifyDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.ModifyDbSubnetGroupRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbSubnetGroupRequest.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ModifyDbSubnetGroupRequest =
      zio.aws.docdb.model.ModifyDbSubnetGroupRequest(
        dbSubnetGroupName,
        dbSubnetGroupDescription.map(value => value),
        subnetIds
      )
    def dbSubnetGroupName: String
    def dbSubnetGroupDescription: Optional[String]
    def subnetIds: List[String]
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest
  ) extends zio.aws.docdb.model.ModifyDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
    override val dbSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroupDescription())
        .map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest
  ): zio.aws.docdb.model.ModifyDbSubnetGroupRequest.ReadOnly = new Wrapper(impl)
}
