package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverDbClusterResponse(
    dbCluster: Optional[zio.aws.docdb.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse = {
    import FailoverDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly =
    zio.aws.docdb.model.FailoverDbClusterResponse.wrap(buildAwsValue())
}
object FailoverDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.FailoverDbClusterResponse =
      zio.aws.docdb.model
        .FailoverDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse
  ) extends zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.docdb.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse
  ): zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly = new Wrapper(impl)
}
