package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GlobalClusterMember(
    dbClusterArn: Optional[String] = Optional.Absent,
    readers: Optional[Iterable[String]] = Optional.Absent,
    isWriter: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.GlobalClusterMember = {
    import GlobalClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.GlobalClusterMember
      .builder()
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        readers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readers)
      .optionallyWith(isWriter.map(value => value: java.lang.Boolean))(
        _.isWriter
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.GlobalClusterMember.ReadOnly =
    zio.aws.docdb.model.GlobalClusterMember.wrap(buildAwsValue())
}
object GlobalClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.GlobalClusterMember =
      zio.aws.docdb.model.GlobalClusterMember(
        dbClusterArn.map(value => value),
        readers.map(value => value),
        isWriter.map(value => value)
      )
    def dbClusterArn: Optional[String]
    def readers: Optional[List[String]]
    def isWriter: Optional[Boolean]
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getReaders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("readers", readers)
    def getIsWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isWriter", isWriter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ) extends zio.aws.docdb.model.GlobalClusterMember.ReadOnly {
    override val dbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterArn())
      .map(value => value: String)
    override val readers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.readers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val isWriter: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isWriter())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.GlobalClusterMember
  ): zio.aws.docdb.model.GlobalClusterMember.ReadOnly = new Wrapper(impl)
}
