package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEventSubscriptionResponse(
    eventSubscription: Optional[zio.aws.docdb.model.EventSubscription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse = {
    import DeleteEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly =
    zio.aws.docdb.model.DeleteEventSubscriptionResponse.wrap(buildAwsValue())
}
object DeleteEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DeleteEventSubscriptionResponse =
      zio.aws.docdb.model.DeleteEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Optional[zio.aws.docdb.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.docdb.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse
  ) extends zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Optional[zio.aws.docdb.model.EventSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscription())
        .map(value => zio.aws.docdb.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse
  ): zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
