package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBEngineVersion(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    dbEngineDescription: Optional[String] = Optional.Absent,
    dbEngineVersionDescription: Optional[String] = Optional.Absent,
    validUpgradeTarget: Optional[Iterable[zio.aws.docdb.model.UpgradeTarget]] =
      Optional.Absent,
    exportableLogTypes: Optional[Iterable[String]] = Optional.Absent,
    supportsLogExportsToCloudwatchLogs: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBEngineVersion = {
    import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBEngineVersion
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        dbEngineDescription.map(value => value: java.lang.String)
      )(_.dbEngineDescription)
      .optionallyWith(
        dbEngineVersionDescription.map(value => value: java.lang.String)
      )(_.dbEngineVersionDescription)
      .optionallyWith(
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validUpgradeTarget)
      .optionallyWith(
        exportableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportableLogTypes)
      .optionallyWith(
        supportsLogExportsToCloudwatchLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsLogExportsToCloudwatchLogs)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBEngineVersion.ReadOnly =
    zio.aws.docdb.model.DBEngineVersion.wrap(buildAwsValue())
}
object DBEngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBEngineVersion =
      zio.aws.docdb.model.DBEngineVersion(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        dbEngineDescription.map(value => value),
        dbEngineVersionDescription.map(value => value),
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportableLogTypes.map(value => value),
        supportsLogExportsToCloudwatchLogs.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def dbEngineDescription: Optional[String]
    def dbEngineVersionDescription: Optional[String]
    def validUpgradeTarget
        : Optional[List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]]
    def exportableLogTypes: Optional[List[String]]
    def supportsLogExportsToCloudwatchLogs: Optional[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDbEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescription)
    def getDbEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbEngineVersionDescription",
        dbEngineVersionDescription
      )
    def getValidUpgradeTarget
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]] =
      AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTarget)
    def getExportableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypes)
    def getSupportsLogExportsToCloudwatchLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsLogExportsToCloudwatchLogs",
        supportsLogExportsToCloudwatchLogs
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ) extends zio.aws.docdb.model.DBEngineVersion.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val dbEngineDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbEngineDescription())
      .map(value => value: String)
    override val dbEngineVersionDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbEngineVersionDescription())
        .map(value => value: String)
    override val validUpgradeTarget
        : Optional[List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validUpgradeTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.UpgradeTarget.wrap(item)
          }.toList
        )
    override val exportableLogTypes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportableLogTypes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportsLogExportsToCloudwatchLogs: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsLogExportsToCloudwatchLogs())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ): zio.aws.docdb.model.DBEngineVersion.ReadOnly = new Wrapper(impl)
}
