package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterToPointInTimeResponse(
    dbCluster: Option[zio.aws.docdb.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse = {
    import RestoreDbClusterToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly =
    zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse
      .wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse =
      zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse
  ) extends zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly {
    override val dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse
  ): zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly =
    new Wrapper(impl)
}
