package zio.aws.docdb.model
import zio.aws.docdb.model.primitives.{BooleanOptional, IntegerOptional, TStamp}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterToPointInTimeRequest(
    dbClusterIdentifier: String,
    sourceDBClusterIdentifier: String,
    restoreToTime: Option[TStamp] = None,
    useLatestRestorableTime: Option[Boolean] = None,
    port: Option[IntegerOptional] = None,
    dbSubnetGroupName: Option[String] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    tags: Option[Iterable[zio.aws.docdb.model.Tag]] = None,
    kmsKeyId: Option[String] = None,
    enableCloudwatchLogsExports: Option[Iterable[String]] = None,
    deletionProtection: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest = {
    import RestoreDbClusterToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .sourceDBClusterIdentifier(sourceDBClusterIdentifier: java.lang.String)
      .optionallyWith(
        restoreToTime.map(value => TStamp.unwrap(value): Instant)
      )(_.restoreToTime)
      .optionallyWith(
        useLatestRestorableTime.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest
      .wrap(buildAwsValue())
}
object RestoreDbClusterToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest =
      zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest(
        dbClusterIdentifier,
        sourceDBClusterIdentifier,
        restoreToTime.map(value => value),
        useLatestRestorableTime.map(value => value),
        port.map(value => value),
        dbSubnetGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value)
      )
    def dbClusterIdentifier: String
    def sourceDBClusterIdentifier: String
    def restoreToTime: Option[TStamp]
    def useLatestRestorableTime: Option[Boolean]
    def port: Option[IntegerOptional]
    def dbSubnetGroupName: Option[String]
    def vpcSecurityGroupIds: Option[List[String]]
    def tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]]
    def kmsKeyId: Option[String]
    def enableCloudwatchLogsExports: Option[List[String]]
    def deletionProtection: Option[BooleanOptional]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSourceDBClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBClusterIdentifier)
    def getRestoreToTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("restoreToTime", restoreToTime)
    def getUseLatestRestorableTime: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("useLatestRestorableTime", useLatestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.docdb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest
  ) extends zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val sourceDBClusterIdentifier: String =
      impl.sourceDBClusterIdentifier(): String
    override val restoreToTime: Option[TStamp] = scala
      .Option(impl.restoreToTime())
      .map(value => zio.aws.docdb.model.primitives.TStamp(value))
    override val useLatestRestorableTime: Option[Boolean] =
      scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val dbSubnetGroupName: Option[String] =
      scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[List[zio.aws.docdb.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enableCloudwatchLogsExports: Option[List[String]] = scala
      .Option(impl.enableCloudwatchLogsExports())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deletionProtection: Option[BooleanOptional] = scala
      .Option(impl.deletionProtection())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest
  ): zio.aws.docdb.model.RestoreDbClusterToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
