package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreDbClusterFromSnapshotResponse(
    dbCluster: Option[zio.aws.docdb.model.DBCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse = {
    import RestoreDbClusterFromSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse
      .wrap(buildAwsValue())
}
object RestoreDbClusterFromSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse =
      zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse
  ) extends zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly {
    override val dbCluster: Option[zio.aws.docdb.model.DBCluster.ReadOnly] =
      scala
        .Option(impl.dbCluster())
        .map(value => zio.aws.docdb.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse
  ): zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
