package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterSnapshotAttributeResponse(
    dbClusterSnapshotAttributesResult: Option[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse = {
    import ModifyDbClusterSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
      .builder()
      .optionallyWith(
        dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbClusterSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse =
      zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse(
        dbClusterSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbClusterSnapshotAttributesResult
        : Option[zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly]
    def getDbClusterSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributesResult",
      dbClusterSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ) extends zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly {
    override val dbClusterSnapshotAttributesResult: Option[
      zio.aws.docdb.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = scala
      .Option(impl.dbClusterSnapshotAttributesResult())
      .map(value =>
        zio.aws.docdb.model.DBClusterSnapshotAttributesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse
  ): zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
