package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterSnapshotAttributeRequest(
    dbClusterSnapshotIdentifier: String,
    attributeName: String,
    valuesToAdd: Option[Iterable[String]] = None,
    valuesToRemove: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest = {
    import ModifyDbClusterSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest
      .builder()
      .dbClusterSnapshotIdentifier(
        dbClusterSnapshotIdentifier: java.lang.String
      )
      .attributeName(attributeName: java.lang.String)
      .optionallyWith(
        valuesToAdd.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToAdd)
      .optionallyWith(
        valuesToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.valuesToRemove)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly =
    zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest
      .wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest =
      zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest(
        dbClusterSnapshotIdentifier,
        attributeName,
        valuesToAdd.map(value => value),
        valuesToRemove.map(value => value)
      )
    def dbClusterSnapshotIdentifier: String
    def attributeName: String
    def valuesToAdd: Option[List[String]]
    def valuesToRemove: Option[List[String]]
    def getDbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterSnapshotIdentifier)
    def getAttributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeName)
    def getValuesToAdd: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToAdd", valuesToAdd)
    def getValuesToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("valuesToRemove", valuesToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest
  ) extends zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly {
    override val dbClusterSnapshotIdentifier: String =
      impl.dbClusterSnapshotIdentifier(): String
    override val attributeName: String = impl.attributeName(): String
    override val valuesToAdd: Option[List[String]] = scala
      .Option(impl.valuesToAdd())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val valuesToRemove: Option[List[String]] = scala
      .Option(impl.valuesToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest
  ): zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
