package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.{IntegerOptional, BooleanOptional}
import scala.jdk.CollectionConverters._
final case class DescribeOrderableDbInstanceOptionsRequest(
    engine: String,
    engineVersion: Option[String] = None,
    dbInstanceClass: Option[String] = None,
    licenseModel: Option[String] = None,
    vpc: Option[BooleanOptional] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest = {
    import DescribeOrderableDbInstanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
      .builder()
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly =
    zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest =
      zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest(
        engine,
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        vpc.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def engine: String
    def engineVersion: Option[String]
    def dbInstanceClass: Option[String]
    def licenseModel: Option[String]
    def vpc: Option[BooleanOptional]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getVpc: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
  ) extends zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly {
    override val engine: String = impl.engine(): String
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbInstanceClass: Option[String] =
      scala.Option(impl.dbInstanceClass()).map(value => value: String)
    override val licenseModel: Option[String] =
      scala.Option(impl.licenseModel()).map(value => value: String)
    override val vpc: Option[BooleanOptional] =
      scala.Option(impl.vpc()).map(value => value: BooleanOptional)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest
  ): zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
