package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbSubnetGroupsResponse(
    marker: Option[String] = None,
    dbSubnetGroups: Option[Iterable[zio.aws.docdb.model.DBSubnetGroup]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse = {
    import DescribeDbSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSubnetGroups)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbSubnetGroupsResponse =
      zio.aws.docdb.model.DescribeDbSubnetGroupsResponse(
        marker.map(value => value),
        dbSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def dbSubnetGroups: Option[List[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbSubnetGroups
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]] =
      AwsError.unwrapOptionField("dbSubnetGroups", dbSubnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse
  ) extends zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbSubnetGroups
        : Option[List[zio.aws.docdb.model.DBSubnetGroup.ReadOnly]] = scala
      .Option(impl.dbSubnetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBSubnetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse
  ): zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
