package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbEngineVersionsResponse(
    marker: Option[String] = None,
    dbEngineVersions: Option[Iterable[zio.aws.docdb.model.DBEngineVersion]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse = {
    import DescribeDbEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbEngineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbEngineVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbEngineVersionsResponse.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbEngineVersionsResponse =
      zio.aws.docdb.model.DescribeDbEngineVersionsResponse(
        marker.map(value => value),
        dbEngineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def dbEngineVersions
        : Option[List[zio.aws.docdb.model.DBEngineVersion.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbEngineVersions: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.DBEngineVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("dbEngineVersions", dbEngineVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse
  ) extends zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val dbEngineVersions
        : Option[List[zio.aws.docdb.model.DBEngineVersion.ReadOnly]] = scala
      .Option(impl.dbEngineVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.DBEngineVersion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse
  ): zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
