package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParametersResponse(
    parameters: Option[Iterable[zio.aws.docdb.model.Parameter]] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse = {
    import DescribeDbClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClusterParametersResponse =
      zio.aws.docdb.model.DescribeDbClusterParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: Option[List[zio.aws.docdb.model.Parameter.ReadOnly]]
    def marker: Option[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse
  ) extends zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly {
    override val parameters
        : Option[List[zio.aws.docdb.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.Parameter.wrap(item)
        }.toList
      )
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse
  ): zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
