package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParametersRequest(
    dbClusterParameterGroupName: String,
    source: Option[String] = None,
    filters: Option[Iterable[zio.aws.docdb.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest = {
    import DescribeDbClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.DescribeDbClusterParametersRequest.ReadOnly =
    zio.aws.docdb.model.DescribeDbClusterParametersRequest.wrap(buildAwsValue())
}
object DescribeDbClusterParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DescribeDbClusterParametersRequest =
      zio.aws.docdb.model.DescribeDbClusterParametersRequest(
        dbClusterParameterGroupName,
        source.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def dbClusterParameterGroupName: String
    def source: Option[String]
    def filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest
  ) extends zio.aws.docdb.model.DescribeDbClusterParametersRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val filters: Option[List[zio.aws.docdb.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest
  ): zio.aws.docdb.model.DescribeDbClusterParametersRequest.ReadOnly =
    new Wrapper(impl)
}
