package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DBEngineVersion(
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    dbParameterGroupFamily: Option[String] = None,
    dbEngineDescription: Option[String] = None,
    dbEngineVersionDescription: Option[String] = None,
    validUpgradeTarget: Option[Iterable[zio.aws.docdb.model.UpgradeTarget]] =
      None,
    exportableLogTypes: Option[Iterable[String]] = None,
    supportsLogExportsToCloudwatchLogs: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBEngineVersion = {
    import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBEngineVersion
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(
        dbEngineDescription.map(value => value: java.lang.String)
      )(_.dbEngineDescription)
      .optionallyWith(
        dbEngineVersionDescription.map(value => value: java.lang.String)
      )(_.dbEngineVersionDescription)
      .optionallyWith(
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validUpgradeTarget)
      .optionallyWith(
        exportableLogTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exportableLogTypes)
      .optionallyWith(
        supportsLogExportsToCloudwatchLogs.map(value =>
          value: java.lang.Boolean
        )
      )(_.supportsLogExportsToCloudwatchLogs)
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBEngineVersion.ReadOnly =
    zio.aws.docdb.model.DBEngineVersion.wrap(buildAwsValue())
}
object DBEngineVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBEngineVersion =
      zio.aws.docdb.model.DBEngineVersion(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbParameterGroupFamily.map(value => value),
        dbEngineDescription.map(value => value),
        dbEngineVersionDescription.map(value => value),
        validUpgradeTarget.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        exportableLogTypes.map(value => value),
        supportsLogExportsToCloudwatchLogs.map(value => value)
      )
    def engine: Option[String]
    def engineVersion: Option[String]
    def dbParameterGroupFamily: Option[String]
    def dbEngineDescription: Option[String]
    def dbEngineVersionDescription: Option[String]
    def validUpgradeTarget
        : Option[List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]]
    def exportableLogTypes: Option[List[String]]
    def supportsLogExportsToCloudwatchLogs: Option[Boolean]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDbEngineDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescription)
    def getDbEngineVersionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbEngineVersionDescription",
        dbEngineVersionDescription
      )
    def getValidUpgradeTarget
        : ZIO[Any, AwsError, List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]] =
      AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTarget)
    def getExportableLogTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypes)
    def getSupportsLogExportsToCloudwatchLogs: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsLogExportsToCloudwatchLogs",
        supportsLogExportsToCloudwatchLogs
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ) extends zio.aws.docdb.model.DBEngineVersion.ReadOnly {
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val dbParameterGroupFamily: Option[String] =
      scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
    override val dbEngineDescription: Option[String] =
      scala.Option(impl.dbEngineDescription()).map(value => value: String)
    override val dbEngineVersionDescription: Option[String] = scala
      .Option(impl.dbEngineVersionDescription())
      .map(value => value: String)
    override val validUpgradeTarget
        : Option[List[zio.aws.docdb.model.UpgradeTarget.ReadOnly]] = scala
      .Option(impl.validUpgradeTarget())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.docdb.model.UpgradeTarget.wrap(item)
        }.toList
      )
    override val exportableLogTypes: Option[List[String]] = scala
      .Option(impl.exportableLogTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val supportsLogExportsToCloudwatchLogs: Option[Boolean] = scala
      .Option(impl.supportsLogExportsToCloudwatchLogs())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBEngineVersion
  ): zio.aws.docdb.model.DBEngineVersion.ReadOnly = new Wrapper(impl)
}
