package zio.aws.docdb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.docdb.model.primitives.IntegerOptional
import scala.jdk.CollectionConverters._
final case class DBClusterMember(
    dbInstanceIdentifier: Option[String] = None,
    isClusterWriter: Option[Boolean] = None,
    dbClusterParameterGroupStatus: Option[String] = None,
    promotionTier: Option[IntegerOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.DBClusterMember = {
    import DBClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.DBClusterMember
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(
        _.isClusterWriter
      )
      .optionallyWith(
        dbClusterParameterGroupStatus.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupStatus)
      .optionallyWith(promotionTier.map(value => value: Integer))(
        _.promotionTier
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.DBClusterMember.ReadOnly =
    zio.aws.docdb.model.DBClusterMember.wrap(buildAwsValue())
}
object DBClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.DBClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.DBClusterMember =
      zio.aws.docdb.model.DBClusterMember(
        dbInstanceIdentifier.map(value => value),
        isClusterWriter.map(value => value),
        dbClusterParameterGroupStatus.map(value => value),
        promotionTier.map(value => value)
      )
    def dbInstanceIdentifier: Option[String]
    def isClusterWriter: Option[Boolean]
    def dbClusterParameterGroupStatus: Option[String]
    def promotionTier: Option[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getIsClusterWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isClusterWriter", isClusterWriter)
    def getDbClusterParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupStatus",
        dbClusterParameterGroupStatus
      )
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterMember
  ) extends zio.aws.docdb.model.DBClusterMember.ReadOnly {
    override val dbInstanceIdentifier: Option[String] =
      scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
    override val isClusterWriter: Option[Boolean] =
      scala.Option(impl.isClusterWriter()).map(value => value: Boolean)
    override val dbClusterParameterGroupStatus: Option[String] = scala
      .Option(impl.dbClusterParameterGroupStatus())
      .map(value => value: String)
    override val promotionTier: Option[IntegerOptional] =
      scala.Option(impl.promotionTier()).map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.DBClusterMember
  ): zio.aws.docdb.model.DBClusterMember.ReadOnly = new Wrapper(impl)
}
