package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateGlobalClusterResponse(
    globalCluster: Option[zio.aws.docdb.model.GlobalCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse = {
    import CreateGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly =
    zio.aws.docdb.model.CreateGlobalClusterResponse.wrap(buildAwsValue())
}
object CreateGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.CreateGlobalClusterResponse =
      zio.aws.docdb.model.CreateGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Option[zio.aws.docdb.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.docdb.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse
  ) extends zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Option[zio.aws.docdb.model.GlobalCluster.ReadOnly] = scala
      .Option(impl.globalCluster())
      .map(value => zio.aws.docdb.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse
  ): zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
