package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourcePendingMaintenanceActions(
    resourceIdentifier: Option[String] = None,
    pendingMaintenanceActionDetails: Option[
      Iterable[zio.aws.docdb.model.PendingMaintenanceAction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActionDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly =
    zio.aws.docdb.model.ResourcePendingMaintenanceActions.wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.docdb.model.ResourcePendingMaintenanceActions =
      zio.aws.docdb.model.ResourcePendingMaintenanceActions(
        resourceIdentifier.map(value => value),
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifier: Option[String]
    def pendingMaintenanceActionDetails
        : Option[List[zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly]]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getPendingMaintenanceActionDetails: ZIO[Any, AwsError, List[
      zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActionDetails",
      pendingMaintenanceActionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions
  ) extends zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly {
    override val resourceIdentifier: Option[String] =
      scala.Option(impl.resourceIdentifier()).map(value => value: String)
    override val pendingMaintenanceActionDetails
        : Option[List[zio.aws.docdb.model.PendingMaintenanceAction.ReadOnly]] =
      scala
        .Option(impl.pendingMaintenanceActionDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.docdb.model.PendingMaintenanceAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions
  ): zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly =
    new Wrapper(impl)
}
